/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests.adapters;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import dev.toma.gunsrpg.common.quests.condition.IQuestConditionProvider;
import dev.toma.gunsrpg.common.quests.condition.QuestConditionLoader;
import dev.toma.gunsrpg.common.quests.quest.DisplayInfo;
import dev.toma.gunsrpg.common.quests.quest.IQuestData;
import dev.toma.gunsrpg.common.quests.quest.QuestConditionTierScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestScheme;
import dev.toma.gunsrpg.common.quests.quest.QuestType;
import dev.toma.gunsrpg.common.quests.quest.QuestTypes;
import dev.toma.gunsrpg.util.helper.JsonHelper;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;

public class QuestSchemeAdapter {
    private final QuestConditionLoader loader;

    public QuestSchemeAdapter(QuestConditionLoader loader) {
        this.loader = loader;
    }

    public <D extends IQuestData> QuestScheme<D> resolveQuestFile(ResourceLocation filePath, JsonElement element) throws JsonParseException {
        JsonObject object = JsonHelper.asJsonObject(element);
        ResourceLocation questTypeId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)object, (String)"type"));
        QuestType questType = QuestTypes.getTypeById(questTypeId);
        if (questType == null) {
            throw new JsonSyntaxException("Unknown quest type: " + questTypeId);
        }
        int tier = JSONUtils.func_151203_m((JsonObject)object, (String)"tier");
        if (tier < 1) {
            throw new JsonSyntaxException("Invalid quest tier: " + tier + ", must be bigger than 0");
        }
        boolean isSpecialTask = JSONUtils.func_151209_a((JsonObject)object, (String)"isSpecial", (boolean)false);
        DisplayInfo displayInfo = DisplayInfo.fromJson(JSONUtils.func_152754_s((JsonObject)object, (String)"display"));
        Object data = questType.resolveJson(object.get("data"));
        IQuestConditionProvider[] conditions = object.has("conditions") ? JsonHelper.deserializeInto(JSONUtils.func_151214_t((JsonObject)object, (String)"conditions"), IQuestConditionProvider[]::new, this.loader::loadCondition) : new IQuestConditionProvider[]{};
        QuestConditionTierScheme tierScheme = QuestConditionTierScheme.EMPTY_SCHEME;
        if (object.has("tieredConditions")) {
            JsonObject tieredConditions = JSONUtils.func_152754_s((JsonObject)object, (String)"tieredConditions");
            tierScheme = QuestConditionTierScheme.fromJson((JsonElement)tieredConditions);
        }
        return new QuestScheme(filePath, questType, data, tier, isSpecialTask, displayInfo, conditions, tierScheme);
    }
}

